<?php
function render_invoice_html($data) {
    $style = $data['template'] ?? 'style1';

    $css = [
        'style1' => "body{font-family:Arial,Helvetica,sans-serif;color:#333;} h1{background:#4CAF50;color:#fff;padding:8px;} table{width:100%;border-collapse:collapse;margin-top:20px;} th,td{border:1px solid #ddd;padding:8px;} th{background:#f2f2f2;} .totals td{border:none;text-align:right;} .totals tr:last-child td{font-weight:bold;} .footer{margin-top:40px;font-size:12px;text-align:center;color:#888;}",
        'style2' => "body{font-family:'Times New Roman',serif;color:#222;} h1{border-bottom:4px double #000;padding-bottom:4px;} table{width:100%;border-collapse:collapse;margin-top:20px;} th,td{border:1px solid #000;padding:8px;} th{background:#eee;} .totals td{border:none;text-align:right;} .totals tr:last-child td{font-weight:bold;} .footer{margin-top:40px;font-size:12px;text-align:center;color:#555;}",
        'style3' => "body{font-family:Verdana,sans-serif;color:#111;} h1{color:#000;text-transform:uppercase;border-bottom:2px solid #000;padding:10px;} table{width:100%;border-collapse:collapse;margin-top:20px;} th,td{border:1px solid #333;padding:6px;} th{background:#ccc;} .totals td{border:none;text-align:right;} .totals tr:last-child td{font-weight:bold;} .footer{margin-top:40px;font-size:12px;text-align:center;color:#222;}"
    ];

    $rows = '';
    $subtotal = 0;
    foreach ($data['items'] as $item) {
        if (empty($item['desc'])) continue;
        $lineTotal = floatval($item['qty']) * floatval($item['price']);
        $subtotal += $lineTotal;
        $rows .= "<tr><td>{$item['desc']}</td><td style=\"text-align:center;\">{$item['qty']}</td><td style=\"text-align:right;\">" . number_format($item['price'],2) . "</td><td style=\"text-align:right;\">" . number_format($lineTotal,2) . "</td></tr>";
    }
    $taxRate = floatval($data['tax'] ?? 0);
    $tax = $subtotal * $taxRate / 100;
    $total = $subtotal + $tax;

    $paidStatus = isset($data['paid']) && $data['paid'] ? "<strong style='color:green;'>PAID</strong>" : "<strong style='color:red;'>UNPAID</strong>";
    $paymentMethod = htmlspecialchars($data['payment_method'] ?? '');

    $logoBase64 = '';
    if (!empty($data['logo_path']) && file_exists($data['logo_path'])) {
        $type = pathinfo($data['logo_path'], PATHINFO_EXTENSION);
        $logoBase64 = 'data:image/' . $type . ';base64,' . base64_encode(file_get_contents($data['logo_path']));
    }

    $html = "<!DOCTYPE html><html><head><meta charset='utf-8'><style>{$css[$style]}</style></head><body>";

    if ($logoBase64) {
        $html .= "<div style='margin-bottom:10px;'><img src='{$logoBase64}' style='max-height:80px;'></div>";
    }

    $html .= "<h1>Invoice</h1>";
    $html .= "<p><strong>Date:</strong> " . htmlspecialchars($data['date']) . "<br><strong>Invoice #:</strong> " . htmlspecialchars($data['invoice_no']) . "<br><strong>Status:</strong> {$paidStatus}<br><strong>Payment Method:</strong> {$paymentMethod}</p>";
    $html .= "<p><strong>From:</strong><br>" . nl2br(htmlspecialchars($data['company'])) . "</p>";
    $html .= "<p><strong>Bill To:</strong><br>" . nl2br(htmlspecialchars($data['client'])) . "</p>";

    $html .= "<table><thead><tr><th>Description</th><th>Qty</th><th>Price</th><th>Total</th></tr></thead><tbody>{$rows}</tbody></table>";
    $html .= "<table class='totals' style='margin-top:20px;width:100%;'>";
    $html .= "<tr><td colspan='3'>Subtotal</td><td>" . number_format($subtotal,2) . "</td></tr>";
    $html .= "<tr><td colspan='3'>Tax (" . number_format($taxRate,2) . "%)</td><td>" . number_format($tax,2) . "</td></tr>";
    $html .= "<tr><td colspan='3'>Grand Total</td><td>" . number_format($total,2) . "</td></tr></table>";

    $html .= "<p class='footer'>Generated by Invoice Generator<br>Thank you for your business!</p>";

    $html .= "</body></html>";

    return $html;
}
?>
