<?php
header_remove("X-Powered-By");
define("BASEPATH", TRUE);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;


require __DIR__ . '/vendor/autoload.php';

// ─── Detect install route FIRST, before loading anything heavy ─────
$_uri_path = parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH);
$_is_install = (stripos($_uri_path, '/install') !== false);

if ($_is_install) {
    // ── Minimal bootstrap for install (no panel DB tables needed) ──
    session_start();
    ob_start();
    $config = require __DIR__ . '/app/config.php';

    try {
        $conn = new PDO(
            "mysql:host=" . $config["db"]["host"] . ";dbname=" . $config["db"]["name"] . ";charset=" . $config["db"]["charset"] . ";",
            $config["db"]["user"],
            $config["db"]["pass"]
        );
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    } catch (PDOException $e) {
        die('Database connection failed: ' . $e->getMessage());
    }

    // Minimal Twig setup for install template
    $loader = new Twig_Loader_Filesystem(__DIR__ . '/app/views/starter');
    $twig   = new Twig_Environment($loader, ['autoescape' => false]);

    $route = ['install'];
    require __DIR__ . '/app/controller/install.php';
    exit;
}

// ─── Normal routes: full init + license verification + routing ─────
$mail = new PHPMailer;
require __DIR__ . '/app/init.php';
require __DIR__ . '/core/bootstrap.php';
require __DIR__ . '/system/twgofficial.php';