<?php
ini_set('max_execution_time', '600');
define("BASEPATH", TRUE);
require $_SERVER["DOCUMENT_ROOT"]."/vendor/autoload.php";
require $_SERVER["DOCUMENT_ROOT"]."/app/init.php";
require $_SERVER["DOCUMENT_ROOT"]."/core/bootstrap.php";

$SMM_API = new SMMApi();

$SELLERS = $conn->prepare("SELECT id, api_name, api_url, api_key, currency FROM service_api WHERE api_sync=:sync");
$SELLERS->execute([
    "sync" => 1
]);
$SELLERS = $SELLERS->fetchAll(PDO::FETCH_ASSOC);
$SELLERS = replaceKeys("id", "api_id", $SELLERS);
$SELLERS = replaceKeys("currency", "api_currency", $SELLERS);

for ($i = 0; $i < count($SELLERS); $i++) {
    $SERVICES_OF_SELLER = $conn->prepare("SELECT * FROM services WHERE service_api=:apitype AND service_sync=:sync");
    $SERVICES_OF_SELLER->execute([
        "apitype" => $SELLERS[$i]["api_id"],
        "sync" => 1
    ]);
    $SERVICES_OF_SELLER = $SERVICES_OF_SELLER->fetchAll(PDO::FETCH_ASSOC);

    if (count($SERVICES_OF_SELLER)) {
        sleep(rand(5, 30));
        $API_SERVICES = $SMM_API->action(
            [
                'key' => $SELLERS[$i]["api_key"], 
                'action' => 'services'
            ],
            $SELLERS[$i]["api_url"]
        );

        if (is_array($API_SERVICES)) {
            $API_SERVICES = json_encode($API_SERVICES, true);
            $API_SERVICES = array_group_by(json_decode($API_SERVICES, true), "service");

            foreach ($SERVICES_OF_SELLER as $service) {
                $PANEL_SERVICE_ID = $service["service_id"];
                $PANEL_API_SERVICE_ID = $service["api_service"];
                $API_DETAIL_JSON = $service["api_detail"];
                $API_DETAIL_ARRAY = json_decode($API_DETAIL_JSON, true);
                $PANEL_SERVICE_PRICE = $service["service_price"];
                $PANEL_SERVICE_MIN_QUANTITY = $service["service_min"];
                $PANEL_SERVICE_MAX_QUANTITY = $service["service_max"];
                $PANEL_PRICE_SERVICE_PROFIT = $service["price_profit"];
                $PANEL_API_SERVICE_TYPE = $service["api_servicetype"];
                $PANEL_SERVICE_SECRET = $service["service_secret"];

                if (!empty($API_SERVICES[$PANEL_API_SERVICE_ID])) {
                    $API_SERVICE_PRICE = $API_SERVICES[$PANEL_API_SERVICE_ID][0]["rate"];
                    $API_SERVICE_MIN_QUANTITY = $API_SERVICES[$PANEL_API_SERVICE_ID][0]["min"];
                    $API_SERVICE_MAX_QUANTITY = $API_SERVICES[$PANEL_API_SERVICE_ID][0]["max"];

                    if ($API_DETAIL_ARRAY["rate"] != $API_SERVICE_PRICE) {
                        // Update API service price
                        $API_DETAIL_ARRAY["rate"] = $API_SERVICE_PRICE;
                        $API_DETAIL_UPDATED_JSON = json_encode($API_DETAIL_ARRAY, JSON_UNESCAPED_UNICODE);
                        $update_api_detail = $conn->prepare("UPDATE services SET api_detail=:detail WHERE service_id=:service_id");
                        $update_api_detail->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "detail" => $API_DETAIL_UPDATED_JSON
                        ]);
                        
                        // Update panel service price
                        $NEW_BASE_CURRENCY_CONVERTED_PANEL_PRICE = from_to(get_currencies_array("all"), $SELLERS[$i]["api_currency"], $settings["site_base_currency"], $API_SERVICE_PRICE);
                        $NEW_PANEL_SERVICE_PRICE = $NEW_BASE_CURRENCY_CONVERTED_PANEL_PRICE + (($PANEL_PRICE_SERVICE_PROFIT / 100) * $NEW_BASE_CURRENCY_CONVERTED_PANEL_PRICE);

                        $update_panel_service_price = $conn->prepare("UPDATE services SET service_price=:price WHERE service_id=:service_id");
                        $update_panel_service_price->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "price" => $NEW_PANEL_SERVICE_PRICE
                        ]);

                        // Insert price change logs
                        $price_change_action = ($NEW_PANEL_SERVICE_PRICE > $PANEL_SERVICE_PRICE) ? "Price Increased" : "Price Decreased";
                        $description = "Service rate changed from <b>" . format_amount_string($settings["site_base_currency"], $PANEL_SERVICE_PRICE) . "</b> to <b>" . format_amount_string($settings["site_base_currency"], $NEW_PANEL_SERVICE_PRICE) . "</b>";
                        
                        $insert_rate_changed_log = $conn->prepare("INSERT INTO sync_logs SET service_id=:service_id, api_id=:api_id, action=:action, description=:description, date=:date");
                        $insert_rate_changed_log->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "api_id" => $SELLERS[$i]["api_id"],
                            "action" => $price_change_action,
                            "description" => $description,
                            "date" => date("Y-m-d H:i:s")
                        ]);

                        // Insert into updates table
                        $insert_updates_log = $conn->prepare("INSERT INTO updates (u_id, service_id, action, date, description) VALUES (NULL, :service_id, :action, :date, :description)");
                        $insert_updates_log->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "action" => $price_change_action,
                            "date" => date("Y-m-d H:i:s"),
                            "description" => $description
                        ]);
                    } 

                    // Check and update minimum quantity
        if ($API_DETAIL_ARRAY["min"] != $API_SERVICE_MIN_QUANTITY) {
            $API_DETAIL_ARRAY["min"] = $API_SERVICE_MIN_QUANTITY;
            $API_DETAIL_UPDATED_JSON = json_encode($API_DETAIL_ARRAY, JSON_UNESCAPED_UNICODE);
            $update_api_detail = $conn->prepare("UPDATE services SET api_detail=:detail WHERE service_id=:service_id");
            $update_api_detail->execute([
                "service_id" => $PANEL_SERVICE_ID,
                "detail" => $API_DETAIL_UPDATED_JSON
            ]);

            $update_service_min_quantity = $conn->prepare("UPDATE services SET service_min=:min WHERE service_id=:service_id");
            $update_service_min_quantity->execute([
                "service_id" => $PANEL_SERVICE_ID,
                "min" => $API_SERVICE_MIN_QUANTITY
            ]);

            // Determine action description for log
            if ($API_SERVICE_MIN_QUANTITY > $PANEL_SERVICE_MIN_QUANTITY) {
                $action_description = "increased";
                $log_action = "Minimum Quantity Increased";
            } else {
                $action_description = "decreased";
                $log_action = "Minimum Quantity Decreased";
            }

            $description = "Service minimum quantity " . $action_description . " from <b>" . $PANEL_SERVICE_MIN_QUANTITY . "</b> to <b>" . $API_SERVICE_MIN_QUANTITY . "</b>";

            $insert_min_changed_log = $conn->prepare("INSERT INTO sync_logs SET service_id=:service_id, api_id=:api_id, action=:action, description=:description, date=:date");
            $insert_min_changed_log->execute([
                "service_id" => $PANEL_SERVICE_ID,
                "api_id" => $SELLERS[$i]["api_id"],
                "action" => $log_action,
                "description" => $description,
                "date" => date("Y-m-d H:i:s")
            ]);

            // Insert into updates table
            $insert_updates_log = $conn->prepare("INSERT INTO updates (u_id, service_id, action, date, description) VALUES (NULL, :service_id, :action, :date, :description)");
            $insert_updates_log->execute([
                "service_id" => $PANEL_SERVICE_ID,
                "action" => $log_action,
                "date" => date("Y-m-d H:i:s"),
                "description" => $description
            ]);
        }

                    // Update service maximum quantity
if ($API_DETAIL_ARRAY["max"] != $API_SERVICE_MAX_QUANTITY) {
    $API_DETAIL_ARRAY["max"] = $API_SERVICE_MAX_QUANTITY;
    $API_DETAIL_UPDATED_JSON = json_encode($API_DETAIL_ARRAY, JSON_UNESCAPED_UNICODE);
    $update_api_detail = $conn->prepare("UPDATE services SET api_detail=:detail WHERE service_id=:service_id");
    $update_api_detail->execute([
        "service_id" => $PANEL_SERVICE_ID,
        "detail" => $API_DETAIL_UPDATED_JSON
    ]);

    $update_service_max_quantity = $conn->prepare("UPDATE services SET service_max=:max WHERE service_id=:service_id");
    $update_service_max_quantity->execute([
        "service_id" => $PANEL_SERVICE_ID,
        "max" => $API_SERVICE_MAX_QUANTITY
    ]);

    // Determine action description for log
    if ($API_SERVICE_MAX_QUANTITY > $PANEL_SERVICE_MAX_QUANTITY) {
        $action_description = "increased";
        $log_action = "Maximum Quantity Increased";
    } else {
        $action_description = "decreased";
        $log_action = "Maximum Quantity Decreased";
    }

    $description = "Service maximum quantity " . $action_description . " from <b>" . $PANEL_SERVICE_MAX_QUANTITY . "</b> to <b>" . $API_SERVICE_MAX_QUANTITY . "</b>";

    $insert_max_changed_log = $conn->prepare("INSERT INTO sync_logs SET service_id=:service_id, api_id=:api_id, action=:action, description=:description, date=:date");
    $insert_max_changed_log->execute([
        "service_id" => $PANEL_SERVICE_ID,
        "api_id" => $SELLERS[$i]["api_id"],
        "action" => $log_action,
        "description" => $description,
        "date" => date("Y-m-d H:i:s")
    ]);

    // Insert into updates table
    $insert_updates_log = $conn->prepare("INSERT INTO updates (u_id, service_id, action, date, description) VALUES (NULL, :service_id, :action, :date, :description)");
    $insert_updates_log->execute([
        "service_id" => $PANEL_SERVICE_ID,
        "action" => $log_action,
        "date" => date("Y-m-d H:i:s"),
        "description" => $description
    ]);
}

                    // Handle service type changes
                    if ($PANEL_API_SERVICE_TYPE == 1) {
                        $update_api_service_type = $conn->prepare("UPDATE services SET api_servicetype=:service_type WHERE service_id=:service_id");
                        $update_api_service_type->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "service_type" => 2
                        ]);

                        if ($PANEL_SERVICE_SECRET == 2) {
                            $update_service_type = $conn->prepare("UPDATE services SET service_type=:service_type WHERE service_id=:service_id");
                            $update_service_type->execute([
                                "service_id" => $PANEL_SERVICE_ID,
                                "service_type" => 2
                            ]);
                        }

                        $insert_service_type_changed_log = $conn->prepare("INSERT INTO sync_logs SET service_id=:service_id, api_id=:api_id, action=:action, description=:description, date=:date");
                        $insert_service_type_changed_log->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "api_id" => $SELLERS[$i]["api_id"],
                            "action" => "SERVICE ADDED BY THE SELLER",
                            "description" => "Service marked <b>ACTIVE</b>",
                            "date" => date("Y-m-d H:i:s")
                        ]);

                        // Insert into updates table
                        $insert_updates_log = $conn->prepare("INSERT INTO updates (u_id, service_id, action, date, description) VALUES (NULL, :service_id, :action, :date, :description)");
                        $insert_updates_log->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "action" => "Activated",
                            "date" => date("Y-m-d H:i:s"),
                            "description" => "Service marked <b>ACTIVE</b>"
                        ]);
                    } 
                } else {
                    if ($PANEL_API_SERVICE_TYPE == 2) {
                        $update_service_type = $conn->prepare("UPDATE services SET api_servicetype=:api_servicetype, service_type=:service_type WHERE service_id=:service_id");
                        $update_service_type->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "api_servicetype" => 1,
                            "service_type" => 1
                        ]);

                        $insert_service_type_changed_log = $conn->prepare("INSERT INTO sync_logs SET service_id=:service_id, api_id=:api_id, action=:action, description=:description, date=:date");
                        $insert_service_type_changed_log->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "api_id" => $SELLERS[$i]["api_id"],
                            "action" => "SERVICE REMOVED BY THE SELLER",
                            "description" => "Service marked <b>INACTIVE</b>",
                            "date" => date("Y-m-d H:i:s")
                        ]);

                        // Insert into updates table
                        $insert_updates_log = $conn->prepare("INSERT INTO updates (u_id, service_id, action, date, description) VALUES (NULL, :service_id, :action, :date, :description)");
                        $insert_updates_log->execute([
                            "service_id" => $PANEL_SERVICE_ID,
                            "action" => "Disabled",
                            "date" => date("Y-m-d H:i:s"),
                            "description" => "Service marked <b>INACTIVE</b>"
                        ]);
                    } 
                }
            } 
        } 
    } 
}
?>