<!-- 
    ===========================
    Theme Author: Evan Ahmed EMon
    Theme Designed By: CJ7 by TWG 
    Contact WhatsApp: +8801864614704
    ===========================
-->
<?php include 'header.php'; ?>
<style>
.orders-table {
    overflow-y: scroll;
    width: 100%;
}

/* Glassy Badges */
.badge-glass-success { background-color: rgba(18, 184, 132, 0.15); color: #109f72; border: 1px solid rgba(18, 184, 132, 0.3); }
.badge-glass-info { background-color: rgba(86, 204, 242, 0.15); color: #007bb5; border: 1px solid rgba(86, 204, 242, 0.3); }
.badge-glass-warning { background-color: rgba(242, 201, 76, 0.15); color: #b28900; border: 1px solid rgba(242, 201, 76, 0.3); }
.badge-glass-danger { background-color: rgba(235, 87, 87, 0.15); color: #c9302c; border: 1px solid rgba(235, 87, 87, 0.3); }
.badge-glass-primary { background-color: rgba(47, 128, 237, 0.15); color: #0056b3; border: 1px solid rgba(47, 128, 237, 0.3); }
.badge-glass-secondary { background-color: rgba(108, 117, 125, 0.15); color: #495057; border: 1px solid rgba(108, 117, 125, 0.3); }
.badge-glass-purple { background-color: rgba(155, 81, 224, 0.15); color: #6f42c1; border: 1px solid rgba(155, 81, 224, 0.3); }

/* Table Card */
.custom-table-card {
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.05);
    border: none;
    margin-top: 15px;
}
.custom-table-card .table thead th {
    border-bottom: 2px solid #f0f0f0;
    color: #444;
    font-weight: 600;
    background: #fdfdfd;
}
.custom-table-card .table tbody tr {
    transition: all 0.2s;
}
.custom-table-card .table tbody tr:hover {
    background-color: #f8f9fa;
}

/* Custom Nav Tabs */
.nav-tabs.modern-tabs {
    border-bottom: none;
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-bottom: 15px;
}
.nav-tabs.modern-tabs > li {
    float: none;
    margin-bottom: 0;
}
.nav-tabs.modern-tabs > li > a {
    border: none !important;
    background: #fff;
    border-radius: 30px !important;
    padding: 8px 16px;
    color: #555;
    font-weight: 500;
    box-shadow: 0 2px 10px rgba(0,0,0,0.03);
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}
.nav-tabs.modern-tabs > li > a:hover {
    background: #f8f9fa;
    transform: translateY(-1px);
}
.nav-tabs.modern-tabs > li.active > a,
.nav-tabs.modern-tabs > li.active > a:hover,
.nav-tabs.modern-tabs > li.active > a:focus {
    background: linear-gradient(135deg, #2F80ED, #56CCF2);
    color: #fff;
    box-shadow: 0 4px 15px rgba(47, 128, 237, 0.3);
}

.order-url {
    margin-right: 10px;
    font-weight: bold;
}

.tooltip5 {
    position: relative;
    display: inline-block;
    cursor: pointer;
}

.tooltip5:hover .tooltiptext5 {
    visibility: visible;
    opacity: 1;
}

.fas.fa-info-circle:hover {
    color: #0056b3;
}

.table-link {
    word-wrap: break-word;
    white-space: normal;
    max-width: 300px;
    overflow-wrap: break-word;
}

.table-responsive {
    overflow-x: auto;
}

/* ===== Dark Mode Support ===== */
body.dark-mode .custom-table-card {
    background: #2a2c33 !important;
    box-shadow: 0 4px 20px rgba(0,0,0,0.2);
}
body.dark-mode .custom-table-card .table thead th {
    background: #31343d !important;
    color: #fff !important;
    border-bottom-color: #3f424c !important;
}
body.dark-mode .custom-table-card .table tbody tr:hover {
    background-color: #353842 !important;
}
body.dark-mode .custom-table-card .table {
    border-color: #3f424c !important;
}
body.dark-mode .nav-tabs.modern-tabs > li > a {
    background: #2a2c33 !important;
    color: #b0b8c8 !important;
    box-shadow: 0 2px 10px rgba(0,0,0,0.15);
}
body.dark-mode .nav-tabs.modern-tabs > li > a:hover {
    background: #353842 !important;
    color: #56CCF2 !important;
}
body.dark-mode .nav-tabs.modern-tabs > li.active > a,
body.dark-mode .nav-tabs.modern-tabs > li.active > a:hover,
body.dark-mode .nav-tabs.modern-tabs > li.active > a:focus {
    background: linear-gradient(135deg, #2F80ED, #56CCF2) !important;
    color: #fff !important;
}
body.dark-mode .badge-glass-success { background-color: rgba(18, 184, 132, 0.2); color: #3ee8a8; border-color: rgba(18, 184, 132, 0.4); }
body.dark-mode .badge-glass-info { background-color: rgba(86, 204, 242, 0.2); color: #56CCF2; border-color: rgba(86, 204, 242, 0.4); }
body.dark-mode .badge-glass-warning { background-color: rgba(242, 201, 76, 0.2); color: #f2c94c; border-color: rgba(242, 201, 76, 0.4); }
body.dark-mode .badge-glass-danger { background-color: rgba(235, 87, 87, 0.2); color: #eb5757; border-color: rgba(235, 87, 87, 0.4); }
body.dark-mode .badge-glass-primary { background-color: rgba(47, 128, 237, 0.2); color: #56CCF2; border-color: rgba(47, 128, 237, 0.4); }
body.dark-mode .badge-glass-secondary { background-color: rgba(108, 117, 125, 0.2); color: #adb5bd; border-color: rgba(108, 117, 125, 0.4); }
body.dark-mode .badge-glass-purple { background-color: rgba(155, 81, 224, 0.2); color: #b98ee8; border-color: rgba(155, 81, 224, 0.4); }
body.dark-mode .table { border-color: #3f424c !important; }
body.dark-mode .table td, body.dark-mode .table th { border-color: #3f424c !important; }
</style>
<div class="container-fluid">
    <div class="dropdown">
    <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
        <?= isset($units['unit']) ? $units['unit'] : 100; ?> Per Page
        <span style="margin-left:8px;" class="caret"></span>
    </button>
    <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
        <li><a href="<?= site_url("admin/orders") ?>?units=100">100 Per Page</a></li>
        <li><a href="<?= site_url("admin/orders") ?>?units=200">200 Per Page</a></li>
        <li><a href="<?= site_url("admin/orders") ?>?units=300">300 Per Page</a></li>
        <li><a href="<?= site_url("admin/orders") ?>?units=400">400 Per Page</a></li>
        <li><a href="<?= site_url("admin/orders") ?>?units=500">500 Per Page</a></li>
    </ul>
</div>
<br>
    
    
            <?php if( $success ): ?>
          <div class="alert alert-success "><?php echo $successText; ?></div>
        <?php endif; ?>
           <?php if( $error ): ?>
          <div class="alert alert-danger "><?php echo $errorText; ?></div>
        <?php endif; ?>
   <ul class="nav nav-tabs modern-tabs p-b">
<li class="<?php if( $status == "all"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders")?>">
        All Orders 
        <span class="badge badge-glass-secondary" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php echo countRow(["table"=>"orders"]) ?></span>
    </a>
</li>
<li class="<?php if( $status == "cronpending"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/cronpending")?>">
        Cron Pending 
        <span class="badge badge-glass-warning" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($cronpendingcount): echo $cronpendingcount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "pending"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/pending")?>">
        Pending 
        <span class="badge badge-glass-primary" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($pendingcount): echo $pendingcount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "processing"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/processing")?>">
        Processing 
        <span class="badge badge-glass-info" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($processingcount): echo $processingcount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "inprogress"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/inprogress")?>">
        Inprogress 
        <span class="badge badge-glass-success" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($inprogresscount): echo $inprogresscount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "completed"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/completed")?>">
        Completed 
        <span class="badge badge-glass-success" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($completedcount): echo $completedcount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "partial"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/partial")?>">
        Partial 
        <span class="badge badge-glass-warning" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($partialcount): echo $partialcount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "canceled"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/canceled")?>">
        Canceled 
        <span class="badge badge-glass-danger" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($canceledcount): echo $canceledcount; else: echo 0; endif; ?></span>
    </a>
</li>
<li class="<?php if( $status == "fail"): echo "active"; endif; ?>">
    <a href="<?=site_url("admin/orders/1/fail")?>">
        Fail 
        <span class="badge badge-glass-purple" style="border-radius: 12px; padding: 5px 10px; font-size: 11px;"><?php if($failCount): echo $failCount; else: echo 0; endif; ?></span>
    </a>
</li> 
    <li class="pull-right custom-search">
    <form class="form-inline search-form" action="<?=site_url("admin/orders")?>" method="get">
        <div class="input-group">
            <input type="text" name="search" class="form-control search-input" value="<?=$search_word?>" placeholder="Search" required>
            <span class="input-group-btn search-select-wrap">
                <select class="form-control search-select" name="search_type">
                    <option value="order_id" <?php if( $search_where == "order_id" ): echo 'selected'; endif; ?>>Order ID</option>
                    <option value="order_url" <?php if( $search_where == "order_url" ): echo 'selected'; endif; ?>>Order URL</option>
                    <option value="username" <?php if( $search_where == "username" ): echo 'selected'; endif; ?>>Username</option>
                    <option value="service_id" <?php if( $search_where == "service_id" ): echo 'selected'; endif; ?>>Service ID</option>
                    <option value="api_orderid" <?php if( $search_where == "api_orderid" ): echo 'selected'; endif; ?>>Api Order ID</option>
                    <option value="api_serviceid" <?php if( $search_where == "api_serviceid" ): echo 'selected'; endif; ?>>Api Service ID</option>
                
                </select>
                <button type="submit" class="btn btn-primary search-button">
                    <span class="fa fa-search" aria-hidden="true"></span>
                </button>
            </span>
        </div>
    </form>
</li>
               
                    
<div class="orders-table">
<div class="card custom-table-card">
    <div class="card-body" style="padding: 0;">
        <table class="table" id="dt" style="margin-bottom: 0;">
            <thead>
         <tr>
            <th class="checkAll-th">
               <div class="checkAll-holder">
                  <input type="checkbox" id="checkAll">
                  <input type="hidden" id="checkAllText" value="order">
               </div>
               <div class="action-block">
                  <ul class="action-list">
                     <li><span class="countOrders"></span> Orders Selected</li>
                     <li>
                        <div class="dropdown">
                           <button type="button" class="btn btn-default btn-xs dropdown-toggle btn-xs-caret" data-toggle="dropdown"> Bulk Actions <span class="caret"></span></button>
                           <ul class="dropdown-menu">
                              <li>
								  <?php if( $status  ==  "fail" ): ?>
                                 <a class="bulkorder" data-type="resend">Resend</a>
                                <?php endif; ?>
                                 <a class="bulkorder" data-type="pending">Pending</a>
                                 <a class="bulkorder" data-type="processing">Processing</a>
                                 <a class="bulkorder" data-type="inprogress">In Progress</a>
                                 <a class="bulkorder" data-type="completed">Completed</a>
                                 <a class="bulkorder" data-type="canceled">Cancel & Refund</a>
                                 
                              </li>
                           </ul>
                        </div>
                     </li>
                  </ul>
               </div>
            </th>
            <th class="p-l">ID</th>
            <th>User</th>
            <th>Charge</th>
            <th>Profit</th>
            <th class="service-block__service">Link</th>
            <th>Start</th>
            <th>Quantity</th>
            <th class="dropdown-th">
              <div class="dropdown">
                <button class="btn btn-th btn-default dropdown-toggle" data-active="<?=$_GET["service_id"]?>" type="button" id="serviceList" data-href="admin/orders/counter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  Service
                  <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" aria-labelledby="dropdownMenu1" id="serviceListContent" style="max-height: 275px; overflow:hidden; overflow-y: scroll">
                </ul>
              </div>
            </th>
            

            <th>Remains</th>
            <th width="5%" class="dropdown-th">
              <div class="dropdown">
                <button class="btn btn-th btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  Status
                  <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                <li class="<?php if( $status == "all"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders")?>">All Orders <span class="badge" style="background-color: #808080"><?php echo countRow(["table"=>"orders"]) ?></span></a></li>
     <li class="<?php if( $status == "cronpending"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/cronpending")?>">Awaiting <span class="badge" style="background-color: #666666"><?php if($cronpendingcount): echo $cronpendingcount; endif; ?></span></a></li>
     <li class="<?php if( $status == "pending"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/pending")?>">Pending <span class="badge" style="background-color: #8470ff"><?php if($pendingcount): echo $pendingcount; endif; ?></span></a></li>
     <li class="<?php if( $status == "processing"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/processing")?>">Processing <span class="badge" style="background-color: #ED7E8A"><?php if($processingcount): echo $processingcount; endif; ?></span></a></li>
     <li class="<?php if( $status == "inprogress"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/inprogress")?>">Inprogress <span class="badge" style="background-color: #00bfff"><?php if($inprogresscount): echo $inprogresscount; endif; ?></span></a></li>
     <li class="<?php if( $status == "completed"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/completed")?>">Completed <span class="badge" style="background-color: #00cd00"><?php if($completedcount): echo $completedcount; endif; ?></span></a></li>
     <li class="<?php if( $status == "partial"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/partial")?>">Partial <span class="badge" style="background-color: #ddc488"><?php if($partialcount): echo $partialcount; endif; ?></span></a></li>
     <li class="<?php if( $status == "canceled"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/canceled")?>">Canceled <span class="badge" style="background-color: #cd5555"><?php if($canceledcount): echo $canceledcount; endif; ?></span></a></li>
     <li class="<?php if( $status == "fail"): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/fail")?>">Fail <span class="badge" style="background-color: #8b3a3a"><?php if($failCount): echo $failCount; endif; ?></span></a></li>
                </ul>
              </div>
            </th>
            <th width="10%">Created at</th> 
            <th width="5%" class="dropdown-th">
              <div class="dropdown">
                <button class="btn btn-th btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  Mode
                  <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                    <li class="<?php if( !$_GET["mode"] ): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/".$status)?>">All</a></li>
                    <li class="<?php if( $_GET["mode"] == "manuel" ): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/".$status)?>?mode=manuel">Manual</a></li>
                    <li class="<?php if( $_GET["mode"] == "auto" ): echo "active"; endif; ?>"><a href="<?=site_url("admin/orders/1/".$status)?>?mode=auto">API</a></li>
                </ul>
              </div>
            </th>
            <th>
                
            </th>
         </tr>
      </thead>
      <form id="changebulkForm" action="<?php echo site_url("admin/orders/multi-action") ?>" method="post">
        <tbody>
          <?php foreach( $orders as $order ): ?>
              <tr>
                 <td><input type="checkbox" class="selectOrder"  name="order[<?php echo $order["order_id"] ?>]" value="1" style="border:1px solid #fff"></td>
                 <td class="p-l">
                  <?php echo $order["order_id"] ?>
                  <?php if( $order["api_orderid"] != 0 ): echo '<div class="label label-api">'.$order["api_orderid"].'</div>'; endif; ?>
                </td>
                 <td><?php echo $order["username"]; if( $order["order_where"] == "api" ): echo ' <span class="label label-api">API</span>'; endif; ?> </td>
                 <td class="service-block__minorder">
                   <div style="width:85px;">
 
<?php echo format_amount_string($settings["site_base_currency"],$order["order_charge"]); ?>
                   
<?php if( $order["service_api"] != 0 ): echo '<div class="service-block__provider-value">'.format_amount_string($settings["site_base_currency"],$order["api_charge"]).'</div>'; endif; ?>
</div>
                 </td>
<td>
  <div style="width:85px;">
    <span style="color: green;">
      <?php echo format_amount_string($settings["site_base_currency"], $order["order_profit"]); ?>
    </span>
  </div>
</td>

<td data-label="Link" class="table-link"><?php echo $order["order_url"]; 
            if(empty($order["order_extras"]) || $order["order_extras"] == "[]"){ }else{
                        echo' <a href="#" class="btn btn-default btn-xs" data-toggle="modal" data-target="#modalDiv" data-action="order_comment" data-id="'.$order["order_id"].'">Comments</a>'; 
                        
                    }
                    ?>
                 </td>
                 <td><?php echo $order["order_start"]; ?></td>
                 <td><?php echo $order["order_quantity"]; ?></td>
                 
<td width="30%">
    <span class="label-id"><?php echo $order["service_id"]; ?></span>
    <?php echo $order["service_name"]; ?>
    
    <?php 
    $api_name = GET_API_NAME_BY_ID($order["order_api"]);
    if ($api_name):
    ?>
        <div class="tooltip5">
            <span class="fas fa-info-circle"></span>
            <span class="tooltiptext5"><?php echo $api_name; ?></span>
        </div>
    <?php endif; ?>
</td>
<td><?php if( $order["order_status"] == "completed" && substr($order["order_remains"], 0,1) == "-" ): echo "+".substr($order["order_remains"], 1);  else: echo $order["order_remains"]; endif; ?></td>
<td>
  <div class="dropdown">
    <?php 
        $btnClass = 'btn-default';
        if($order["order_status"] == 'completed') $btnClass = 'badge-glass-success';
        elseif($order["order_status"] == 'processing') $btnClass = 'badge-glass-info';
        elseif($order["order_status"] == 'pending') $btnClass = 'badge-glass-primary';
        elseif($order["order_status"] == 'inprogress') $btnClass = 'badge-glass-success';
        elseif($order["order_status"] == 'partial') $btnClass = 'badge-glass-warning';
        elseif($order["order_status"] == 'canceled' || $order["order_status"] == 'fail') $btnClass = 'badge-glass-danger';
    ?>
    <button class="btn btn-th <?= $btnClass ?> dropdown-toggle" style="border-radius: 20px; padding: 4px 12px; font-size: 12px; font-weight: 500;" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      <?php echo orderStatu($order["order_status"], $order["order_error"], $order["order_detail"]); ?>
      <span class="caret"></span>
    </button>
    <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
      <?php if( $order["order_status"] == "pending" || $order["order_status"] == "completed" || $order["order_status"] == "processing" || $order["order_status"] == "partial" || $order["order_status"] == "fail" ): ?>
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_cancel/".$order["order_id"])?>">Cancel & Refund</a></li>
      <?php endif; ?>
      
      <?php if( $order["order_status"] == "pending" || $order["order_status"] == "inprogress" || $order["order_status"] == "processing" ): ?>           
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_complete/".$order["order_id"])?>">Complete</a></li>
      <?php endif; ?>             

      <?php if( $order["order_status"] == "pending" || $order["order_status"] == "processing" ): ?>
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_inprogress/".$order["order_id"])?>">In Progress</a></li>
      <?php endif; ?>   
     
      <?php if( $order["order_status"] == "pending" || $order["order_status"] == "processing" ): ?>
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_processing/".$order["order_id"])?>">Processing</a></li>
      <?php endif; ?>

     
    </ul>
  </div>
</td>


<td width="10%" style="white-space: nowrap;">
    <?php 
    echo $order["order_create"]; 
    ?>

    <br>
    <span style="color: gray; ">
        <i class="fas fa-stopwatch" style="color: gray; margin-right: 5px;"></i>
        <?php 
        $order_create = $order["order_create"];
        $current_time = new DateTime();
        $order_time = new DateTime($order_create);
        $interval = $current_time->diff($order_time);

        $time_parts = [];

        if ($interval->y > 0) {
            $time_parts[] = $interval->y . " year" . ($interval->y > 1 ? "s" : "");
        }
        if ($interval->m > 0) {
            $time_parts[] = $interval->m . " month" . ($interval->m > 1 ? "s" : "");
        }
        if ($interval->d >= 7) {
            $weeks = floor($interval->d / 7);
            $time_parts[] = $weeks . " week" . ($weeks > 1 ? "s" : "");
        }
        if ($interval->d > 0 && $interval->d < 7) {
            $time_parts[] = $interval->d . " day" . ($interval->d > 1 ? "s" : "");
        }
        if ($interval->h > 0) {
            $time_parts[] = $interval->h . " hour" . ($interval->h > 1 ? "s" : "");
        }
        if ($interval->i > 0) {
            $time_parts[] = $interval->i . " minute" . ($interval->i > 1 ? "s" : "");
        }
        if ($interval->s > 0) {
            $time_parts[] = $interval->s . " second" . ($interval->s > 1 ? "s" : "");
        }

        echo implode(", ", $time_parts) . " ago";
        ?>
    </span>
</td>
    
                 <td width="5%"><?php if( $order["api_service"] == 0 ): echo "Manual"; else: echo "Automatic"; endif; ?></td>
                 <td class="service-block__action">
                   <div class="dropdown pull-right">
                     <button type="button" class="btn btn-default btn-xs dropdown-toggle btn-xs-caret" data-toggle="dropdown">Options <span class="caret"></span></button>
                     <ul class="dropdown-menu">
                       <?php if( $order["order_error"] != "-" && $order["service_api"] != 0 ): ?>
                         <li><a href="#"  data-toggle="modal" data-target="#modalDiv" data-action="order_errors" data-id="<?php echo $order["order_id"] ?>">Order Errors</a></li>
                         <li><a href="<?=site_url("admin/orders/order_resend/".$order["order_id"])?>">Forward Order</a></li>
                       <?php endif; ?>
                       <?php if( $order["order_error"] == "-" && $order["service_api"] != 0 ): ?>
                         <li><a href="#"  data-toggle="modal" data-target="#modalDiv" data-action="order_details" data-id="<?php echo $order["order_id"] ?>">Order Details</a></li>
                       <?php endif; ?>
                       <?php if( $order["service_api"] == 0 || $order["order_error"] != "-"  ): ?>
                         <li><a href="#"  data-toggle="modal" data-target="#modalDiv" data-action="order_orderurl" data-id="<?php echo $order["order_id"] ?>">Set Order URL</a></li>
                       <?php endif; ?>
                         <li><a href="#"  data-toggle="modal" data-target="#modalDiv" data-action="order_startcount" data-id="<?php echo $order["order_id"] ?>">Set Start Count</a></li>
                      
                       <?php if( $order["order_status"] != "partial"): ?>
                         <li><a href="#"  data-toggle="modal" data-target="#modalDiv" data-action="order_partial" data-id="<?php echo $order["order_id"] ?>">Set Partial</a></li>
                       <?php endif; ?>
<hr>
 <?php if( $order["order_status"] == "pending" || $order["order_status"] == "completed" || $order["order_status"] == "processing" || $order["order_status"] == "partial" || $order["order_status"] == "fail" ): ?>
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_cancel/".$order["order_id"])?>">Cancel & Refund</a></li>
      <?php endif; ?>
      
      <?php if( $order["order_status"] == "pending" || $order["order_status"] == "inprogress" || $order["order_status"] == "processing" ): ?>           
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_complete/".$order["order_id"])?>">Complete</a></li>
      <?php endif; ?>             

      <?php if( $order["order_status"] == "pending" || $order["order_status"] == "processing" ): ?>
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_inprogress/".$order["order_id"])?>">In Progress</a></li>
      <?php endif; ?>  
     
           <?php if( $order["order_status"] == "pending" || $order["order_status"] == "processing" ): ?>
        <li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_processing/".$order["order_id"])?>">Processing</a></li>
      <?php endif; ?>

<?php if( $order["refill"]  ==  "1" || $order["refill"]  ==  "2" || $order["status_order"]  ==  "Completed" ): ?>
<li><a href="#" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/orders/order_refill_activate/".$order["order_id"])?>">Activate Refill Button</a></li>
<?php endif; ?>

                     </ul>
                   </div>
                 </td>
              </tr>
            <?php endforeach; ?>
        </tbody>
        <input type="hidden" name="bulkStatus" id="bulkStatus" value="0">
      </form>
   </table>
    </div> <!-- end card-body -->
</div> <!-- end custom-table-card -->
</div>
   <?php if( $paginationArr["count"] > 1 ): ?>
     <div class="row">
        <div class="col-sm-8">
           <nav>
              <ul class="pagination">
                <?php if( $paginationArr["current"] != 1 ): ?>
                 <li class="prev"><a href="<?php echo site_url("admin/orders/1/".$status.$search_link) ?>">&laquo;</a></li>
                 <li class="prev"><a href="<?php echo site_url("admin/orders/".$paginationArr["previous"]."/".$status.$search_link) ?>">&lsaquo;</a></li>
                 <?php
                     endif;
                     for ($page=1; $page<=$pageCount; $page++):
                       if( $page >= ($paginationArr['current']-9) and $page <= ($paginationArr['current']+9) ):
                 ?>
                 <li class="<?php if( $page == $paginationArr["current"] ): echo "active"; endif; ?> "><a href="<?php echo site_url("admin/orders/".$page."/".$status.$search_link) ?>"><?=$page?></a></li>
                 <?php endif; endfor;
                       if( $paginationArr["current"] != $paginationArr["count"] ):
                 ?>
                 <li class="next"><a href="<?php echo site_url("admin/orders/".$paginationArr["next"]."/".$status.$search_link) ?>" data-page="1">&rsaquo;</a></li>
                 <li class="next"><a href="<?php echo site_url("admin/orders/".$paginationArr["count"]."/".$status.$search_link) ?>" data-page="1">&raquo;</a></li>
                 <?php endif; ?>
              </ul>
           </nav>
        </div>
        <div class="col-sm-4 pagination-counters">
          <?php echo $count; ?> from within the order <?php echo $where+1 ?>'den <?php if( $where+$to > $count ): echo $count; else: echo $where+$to; endif; ?>'up to
         </div>
     </div>
   <?php endif; ?>
</div>
<div class="modal modal-center fade" id="confirmChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
   <div class="modal-dialog modal-dialog-center" role="document">
      <div class="modal-content">
         <div class="modal-body text-center">
            <h4>Are you sure you want to update the status?</h4>
            <div align="center">
               <a class="btn btn-primary" href="" id="confirmYes">Yes</a>
               <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
            </div>
         </div>
      </div>
   </div>
</div>

<?php include 'footer.php'; ?>
