
 <?php include 'header.php'; ?>


<style>

/* Global Styles */
html, body {
    width: 100%;
    height: 100%;
    margin: 0;
    padding: 0;
    overflow-x: hidden; 
}

/* Padding & Margin Utilities */
.pt-4 { padding-top: 1.5rem !important; }
.px-4 { padding-right: 1.5rem !important; padding-left: 1.5rem !important; }
.g-4, .gy-4 { --bs-gutter-y: 1.5rem; }
.g-4, .gx-4 { --bs-gutter-x: 1.5rem; }
.rounded { border-radius: 5px !important; }
.p-4 { padding: 1.5rem !important; }
.align-items-center { align-items: center !important; }
.justify-content-between { justify-content: space-between !important; }
.d-flex { display: flex !important; }
.text-primary { color: #FF6F61 !important; } /* Coral */
.ms-3 { margin-left: 1rem !important; }
.mb-2 { margin-bottom: .5rem !important; }
.mb-0 { margin-bottom: 0 !important; }

/* Statistics Card */
.satistics { 
    margin: 5px; 
    border-radius: 10px; 
    box-shadow: 0 .46875rem 2.1875rem rgba(4,9,20,.03), 0 .9375rem 1.40625rem rgba(4,9,20,.03), 0 .25rem .53125rem rgba(4,9,20,.05), 0 .125rem .1875rem rgba(4,9,20,.03);
    transition: all .2s;
    background: linear-gradient(135deg, #3E8E41, #64C700); /* Fresh Green Gradient */
}
.satistics { margin-bottom: 10px; }

/* Button Style */
.button-1 {
    background-color: #3B6EE4; /* Sky Blue */
    border-radius: 5px;
    border-style: none;
    color: #FFFFFF;
    font-family: "Haas Grot Text R Web", "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size: 14px;
    font-weight: 500;
    height: 40px;
    padding: 10px 16px;
    text-align: center;
    cursor: pointer;
    outline: none;
    transition: background-color 0.3s ease;
}
.button-1:hover { background-color: #2A58B2; } /* Darker Blue on Hover */
body.dark-mode .button-1 { color: #fff; }

/* Flexbox and Card Stretch */
.stretch-card { display: -webkit-flex; display: flex; align-items: stretch; justify-content: stretch; }
.grid-margin { margin-bottom: 1.875rem; }
.stretch-card > .card { width: 100%; min-width: 100%; }
.card { 
    position: relative; 
    display: flex; 
    flex-direction: column; 
    min-width: 0; 
    background: linear-gradient(135deg, #2F3C7E, #000428); /* Deep Blue Gradient */
    border-radius: 0.625rem; 
    box-shadow: 5px 11px 23px -13px #e5e5e5;
}
body.dark-mode .card { box-shadow: none; }

/* Card Body */
.card-body { flex: 1 1 auto; padding: 1.25rem; }
.card .card-body { padding: 1.25rem 1.25rem; }

/* Icon Card Styles */
.icon-card-primary .icon, .icon-card-success .icon, .icon-card-dark .icon, .icon-card-info .icon {
    width: 30px;
    height: 30px;
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.3);
    text-align: center;
}
.icon i { font-size: 17px; line-height: 30px; text-align: center; color: white; }
.font-weight-medium { font-weight: 500; }
p { font-size: 1.4rem; margin-bottom: .5rem; line-height: 1.3rem; }

/* Margin Utilities */
.mt-3 { margin-top: 1rem !important; }
.flex-wrap { flex-wrap: wrap !important; }
.font-weight-normal { font-weight: 400 !important; }
.mr-2 { margin-right: 0.5rem !important; }
.mb-0, .my-0 { margin-bottom: 0 !important; }

/* Badge Styles */
.badges { display: inline-block; padding: 0.25em 0.4em; font-size: 75%; font-weight: 700; line-height: 1; text-align: center; background-color: transparent; margin-top: 18px; border-radius: 0.25rem; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; }
body.dark-mode .badge { background-color: transparent; color: #fff; }
.badge-pill { padding-right: 0.6em; padding-left: 0.6em; border-radius: 10rem; }
.badge { border-radius: 4px; font-size: 11px; padding: .475rem .5625rem; font-weight: normal; }

/* Icon Card Colors */
.icon-card-info {
    background: linear-gradient(135deg, #FF4E50, #FC913A, #FF6F61) !important; /* Red, Orange, and Pink Blend */
    color: #ffffff;
}
.icon-card-primary { background: linear-gradient(135deg, #283C5C, #3A3F85) !important; color: #ffffff; } /* Navy Blue */
.icon-card-success {
    background: linear-gradient(135deg, #56ab2f, #a8e063) !important; /* Bright Green to Light Green */
    color: #ffffff;
}
.icon-card-dark {
    background: linear-gradient(135deg, #42047e, #07f49e) !important; /* Purple to Aqua Green */
    color: #ffffff;
}
.icon-card-secondary { background: linear-gradient(135deg, #4C4E56, #D8D8D8) !important; color: #ffffff; } /* Grey to Light Grey */
.icon-card-danger { background: linear-gradient(135deg, #9B2C2C, #E74C3C) !important; color: #ffffff; } /* Red */
.icon-card-bd { background: linear-gradient(135deg, #56CCF2, #2F80ED) !important; color: #ffffff; } /* Sky Blue */
.icon-card-man {
    background: linear-gradient(135deg, #6A1B9A, #D32F2F) !important; /* Purple and Red Blend */
    color: #ffffff;
}
.icon-card-bgt { background: linear-gradient(135deg, #4E586E, #8A9AC8) !important; color: #ffffff; } /* Slate Blue */
.icon-card-glow {
    background: linear-gradient(135deg, #00B0FF, #81D4FA, #1976D2, #004D40) !important; /* Sky Blue, Light Blue, Navy Blue, Teal */
    color: #ffffff;
}
</style>


<div class="container-fluid">
<?php if ($admin["two_factor"] == 0) : ?>
    <div class="alert alert-danger" id="two-factor-alert" 
         style="position: relative; padding: 5px; background-color: #f8d7da; 
                border: 1px solid #f5c6cb; color: #721c24; border-radius: 5px; 
                display: flex; justify-content: space-between; align-items: center; 
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
        <div style="display: flex; align-items: center;">
            <strong><i class="fa fa-exclamation-circle" style="margin-right: 5px; font-size: 18px;"></i></strong>
            <span style="font-size: 14px; font-weight: bold;">
                2FACTOR AUTHENTICATION IS DISABLED! TURN ON FOR EXTRA SECURITY.
            </span>
        </div>
        <div style="display: flex; align-items: center;">
            <a class="btn btn-danger btn-xs" 
               href="<?php echo site_url('admin/activate-google-2fa') ?>" 
               style="font-size: 12px; color: white; text-decoration: none; margin-right: 10px; 
                      padding: 5px 10px; background-color: #dc3545; border-radius: 5px;">
                <i class="fa fa-shield-alt"></i> Enable Now
            </a>
            <span class="closebtn" onclick="document.getElementById('two-factor-alert').style.display='none';" 
                  style="font-size: 18px; cursor: pointer; color: #721c24;">&times;</span>
        </div>
    </div>
<?php endif; ?>
    <div class="row">
<!-- Users Card -->
<div class="col-12 col-sm-6 col-md-3 grid-margin stretch-card">
    <div class="card icon-card-primary" style="background: linear-gradient(135deg, #283C5C, #3A3F85);">
        <a style="text-decoration:none;color:#fff;" href="admin/clients">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
                        <i class="fa fa-users"></i>
                    </div>
                    <p class="font-weight-medium mb-0">Clients</p>
                </div>
                <div class="d-flex align-items-center mt-3 flex-wrap">
                    <h3 class="font-weight-normal mb-0 mr-2"><?php echo countRow(["table"=>"clients"]) ?></h3>
                    <div class="badge badge-outline-light badge-pill mt-md-2 mt-xl-0">
                        <div class="d-flex align-items-baseline">
                            <?php 
                            $clients = $conn->prepare("SELECT * FROM clients");
                            $clients->execute();
                            $clients = $clients->fetchAll(PDO::FETCH_ASSOC);
                            $month = date('m');
                            $previous_month = date("m", strtotime('-1 month', strtotime(date('Y-m-d'))));
                            
                            $count_this_month = 0;
                            $count_previous_month = 0;
                            $today = date('Y-m-d'); // Current date
                            $count_today_users = 0; // To track today's users

                            foreach ($clients as $client) {
                                $register_month = explode("-", explode(" ", $client["register_date"])[0])[1];
                                $register_date = explode(" ", $client["register_date"])[0]; // Extracting only date part
                                
                                // Check if the user registered this month or last month
                                if ($register_month == $month) {
                                    $count_this_month++;
                                }
                                if ($register_month == $previous_month) {
                                    $count_previous_month++;
                                }

                                // Check if the user registered today
                                if ($register_date == $today) {
                                    $count_today_users++;
                                }
                            }

                            // Calculate growth in users
                            $show_users = $count_this_month - $count_previous_month;
                            $growth_users = ($show_users >= 0) ? 
                                '<span class="mb-0 mr-2">'.$count_today_users.'</span><i class="fas fa-arrow-up"></i>' :
                                '<span class="mb-0 mr-2">'.abs($count_today_users).'</span><i class="fas fa-arrow-down"></i>';
                            ?>
                            <?=$growth_users?>
                        </div>
                    </div>
                </div>
                <small class="font-weight-medium d-block mt-2">Total</small>
            
            </div>
        </a>
    </div>
</div>

<!-- Orders Card -->
<div class="col-12 col-sm-6 col-md-3 grid-margin stretch-card">
    <div class="card icon-card-success" style="background: linear-gradient(135deg, #12B884, #8CF9A5);">
        <a style="text-decoration:none;color:#ffffff;" href="/admin/orders">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <p class="font-weight-medium mb-0">Orders</p>
                </div>
                <div class="d-flex align-items-center mt-3 flex-wrap">
                    <h3 class="font-weight-normal mb-0 mr-2"><?php echo countRow(["table"=>"orders"]) ?></h3>
                    <div class="badge badge-outline-light badge-pill mt-md-2 mt-xl-0">
                        <div class="d-flex align-items-baseline">
                            <span class="mr-2"></span>
                            <?php 
                            $orders = $conn->prepare("SELECT * FROM orders");
                            $orders->execute();
                            $orders = $orders->fetchAll(PDO::FETCH_ASSOC);
                            $count_this_month_orders = 0;
                            $count_previous_month_orders = 0;
                            $count_today_orders = 0; // To track today's orders

                            foreach ($orders as $order) {
                                $order_month = explode("-", explode(" ", $order["order_create"])[0])[1];
                                $order_date = explode(" ", $order["order_create"])[0]; // Extracting only date part

                                // Check if the order was placed this month or last month
                                if ($order_month == $month) {
                                    $count_this_month_orders++;
                                }
                                if ($order_month == $previous_month) {
                                    $count_previous_month_orders++;
                                }

                                // Check if the order was placed today
                                if ($order_date == $today) {
                                    $count_today_orders++;
                                }
                            }

                            // Calculate growth in orders
                            $show_orders = $count_this_month_orders - $count_previous_month_orders;
                            $growth_orders = ($show_orders >= 0) ? 
                                '<span class="mb-0 mr-2">'. $count_today_orders .'</span><i class="fas fa-arrow-up"></i>' :
                                '<span class="mb-0 mr-2">'.abs($count_today_orders).'</span><i class="fas fa-arrow-down"></i>';
                         
                           ?>
                            <?=$growth_orders?>
                        </div>
                    </div>
                </div>
                <small class="font-weight-medium d-block mt-2">Total</small>
        
            </div>
        </a>
    </div>
</div>
        <!-- Active Services Card -->
        <div class="col-12 col-sm-6 col-md-3 grid-margin stretch-card">
            <div class="card icon-card-bd" style="background: linear-gradient(135deg, #56CCF2, #2F80ED);">
                <a style="text-decoration:none;color:#ffffff;" href="/admin/services">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
                                <i class="fas fa-cogs"></i>
                            </div>
                            <p class="font-weight-medium mb-0">Total Active Services</p>
                        </div>
                        <div class="d-flex align-items-center mt-3 flex-wrap">
                            <h3 class="font-weight-normal mb-0 mr-2"><?php echo countRow(["table"=>"services"]) ?></h3>
                        </div>
                        <small class="font-weight-medium d-block mt-2">Total</small>
                    </div>
                </a>
            </div>
        </div>

        <!-- Undead Tickets Card -->
        <div class="col-12 col-sm-6 col-md-3 grid-margin stretch-card">
            <div class="card icon-card-man" style="background: linear-gradient(135deg, #F6A5C0, #F285AB);">
                <a style="text-decoration:none;color:#ffffff;" href="/admin/tickets?search=unread">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
                                <i class="fas fa-ticket-alt"></i>
                            </div>
                            <p class="font-weight-medium mb-0">Undead Tickets</p>
                        </div>
                        <div class="d-flex align-items-center mt-3 flex-wrap">
                            <h3 class="font-weight-normal mb-0 mr-2"><?php echo countRow(["table"=>"tickets"]) ?></h3>
                        </div>
                        <small class="font-weight-medium d-block mt-2">Total</small>
                    </div>
                </a>
            </div>
        </div>

        <!-- Failed Orders Card -->
        <div class="col-12 col-sm-6 col-md-3 grid-margin stretch-card">
            <div class="card icon-card-info" style="background: linear-gradient(135deg, #00A8A6, #6EC5B7);">
                <a style="text-decoration:none;color:#ffffff;" href="/admin/orders/1/fail">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
                                <i class="glyphicon glyphicon-remove"></i>
                            </div>
                            <p class="font-weight-medium mb-0">Failed Orders</p>
                        </div>
                        <div class="d-flex align-items-center mt-3 flex-wrap">
                            <h3 class="font-weight-normal mb-0 mr-2"><?php echo $failCount ?></h3>
                        </div>
                        <small class="font-weight-medium d-block mt-2">Total</small>
                    </div>
                </a>
            </div>
        </div>
        
        
        
       
               <div class="col-md-12 col-sm-6 col-md-3 grid-margin stretch-card">
 <div class="card icon-card-bgt ">
     <a style="text-decoration:none;color:#fff;" href="/admin/orders/1/all?mode=manuel">
   <div class="card-body">
<div class="d-flex align-items-center">
  <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
    <i class="fas fa-headset"></i>
 </div>
   <p class="font-weight-medium mb-0">Manual Orders</p>
</div>
<div class="d-flex align-items-center mt-3 flex-wrap">
  <h3 class="font-weight-normal mb-0 mr-2"><?php echo countRow(["table"=>"orders","where"=>["api_orderid"=>0] ]) ?></h3>
</div>
<small class="font-weight-medium d-block mt-2">Total</small>
                </div>
                </a>
            </div>
        </div> 
        
<!-- Funds Added Today Card -->
<div class="col-12 col-sm-6 col-md-3 grid-margin stretch-card">
    <div class="card icon-card-dark" style="background: linear-gradient(135deg, #1A202C, #2F3C58);">
        <div class="card-body">
            <div class="d-flex align-items-center">
                <div class="icon mb-0 mb-md-2 mb-xl-0 mr-2">
                    <i class="glyphicon glyphicon-usd"></i>
                </div>
                <p class="font-weight-medium mb-0">Total Funds Added Today</p>
            </div>
            <div class="d-flex align-items-center mt-3 flex-wrap">
                <h3 class="font-weight-normal mb-0 mr-2">
                    <?php 
                        echo $settings["site_currency"];
                        // Calculate today's total completed payments (where payment_status = 3)
                        $today_start = date('Y-m-d 00:00:00'); // Today's start time
                        $today_end = date('Y-m-d 23:59:59');   // Today's end time
                        $query = $conn->prepare("SELECT SUM(payment_amount) as total FROM payments 
                                                 WHERE payment_create_date BETWEEN :start AND :end 
                                                 AND payment_status = 3"); // Check for payment_status = 3 (completed)
                        $query->execute(["start" => $today_start, "end" => $today_end]);
                        $result = $query->fetch(PDO::FETCH_ASSOC);
                        echo $result['total'] ? $result['total'] : 0; // Show total or 0 if null
                    ?>
                </h3>
            </div>
            <small class="font-weight-medium d-block mt-2">Total</small>
        </div>
    </div>
</div>
    </div> <!-- End of Top Stats Row -->

    <!-- ==========================================
         NEW MODERN CHARTS & DATA VISUALIZATION 
         ========================================== -->
    <div class="row mt-4">
        <!-- Revenue Line Chart -->
        <div class="col-12 col-lg-8 grid-margin stretch-card">
            <div class="card icon-card-primary" style="box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
                <div class="card-body">
                    <h4 style="color: #ffffff; font-weight: 600; margin-bottom: 20px;"><i class="bi bi-graph-up-arrow"></i> Revenue Overview (<?= date("Y") ?>)</h4>
                    <div style="position: relative; height: 350px; width: 100%;">
                        <canvas id="revenueChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Status Doughnut Chart -->
        <div class="col-12 col-lg-4 grid-margin stretch-card">
            <div class="card icon-card-dark" style="box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
                <div class="card-body">
                    <h4 style="color: #ffffff; font-weight: 600; margin-bottom: 20px;"><i class="bi bi-pie-chart"></i> Order Status</h4>
                    <div style="position: relative; height: 300px; width: 100%; display: flex; justify-content: center; align-items: center;">
                        <canvas id="statusChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- Monthly Orders Bar Chart -->
        <div class="col-12 col-lg-6 grid-margin stretch-card">
            <div class="card icon-card-bd" style="box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
                <div class="card-body">
                    <h4 style="color: #ffffff; font-weight: 600; margin-bottom: 20px;"><i class="bi bi-bar-chart"></i> Orders Trend (<?= date("Y") ?>)</h4>
                    <div style="position: relative; height: 300px; width: 100%;">
                        <canvas id="ordersChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity Table -->
        <div class="col-12 col-lg-6 grid-margin stretch-card">
            <div class="card icon-card-man" style="box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
                <div class="card-body" style="padding: 1.5rem; overflow-x: auto;">
                    <h4 style="color: #ffffff; font-weight: 600; margin-bottom: 20px;"><i class="bi bi-clock-history"></i> Recent Orders</h4>
                    <table class="table" style="color: #ffffff; width: 100%;">
                        <thead>
                            <tr style="border-bottom: 2px solid rgba(255,255,255,0.2);">
                                <th style="border-top: none; color: #fff;">ID</th>
                                <th style="border-top: none; color: #fff;">User</th>
                                <th style="border-top: none; color: #fff;">Service</th>
                                <th style="border-top: none; color: #fff;">Status</th>
                                <th style="border-top: none; color: #fff;">Charge</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($recentOrders)): foreach($recentOrders as $ro): ?>
                            <tr style="border-bottom: 1px solid rgba(255,255,255,0.1);">
                                <td style="font-weight: 500;">#<?= $ro['order_id'] ?></td>
                                <td><?= htmlspecialchars($ro['username']) ?></td>
                                <td style="max-width: 150px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;" title="Service ID: <?= $ro['service_id'] ?>">S-<?= $ro['service_id'] ?></td>
                                <td>
                                    <?php 
                                        $bgHtml = 'background-color: rgba(255,255,255,0.2); color: #fff;';
                                        if($ro['order_status'] == 'completed') $bgHtml = 'background-color: #12B884; color: #fff; border: 1px solid #109f72;';
                                        if($ro['order_status'] == 'processing') $bgHtml = 'background-color: #56CCF2; color: #fff; border: 1px solid #45a4c2;';
                                        if($ro['order_status'] == 'pending') $bgHtml = 'background-color: #F2C94C; color: #333; border: 1px solid #c2a13d;';
                                        if($ro['order_status'] == 'canceled' || $ro['order_status'] == 'fail') $bgHtml = 'background-color: #EB5757; color: #fff; border: 1px solid #bc4646;';
                                    ?>
                                    <span class="badges" style="font-size: 10px; padding: 5px 8px; border-radius: 4px; <?= $bgHtml ?>"><?= ucfirst($ro['order_status']) ?></span>
                                </td>
                                <td style="font-weight: 600; text-shadow: 0px 1px 2px rgba(0,0,0,0.3);"><?= $settings['site_currency'] ?> <?= $ro['order_charge'] ?></td>
                            </tr>
                            <?php endforeach; else: ?>
                            <tr>
                                <td colspan="5" class="text-center" style="border-top: none;">No recent orders found.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div> <!-- End Container Fluid -->

<!-- Chart.js Library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Shared Chart Configuration
    Chart.defaults.font.family = "'Inter', 'Helvetica Neue', 'Helvetica', 'Arial', sans-serif";
    Chart.defaults.color = '#ffffff'; // White text for dark colorful backgrounds
    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

    // 1. Revenue Line Chart
    const revenueCtx = document.getElementById('revenueChart').getContext('2d');
    const revenueGradient = revenueCtx.createLinearGradient(0, 0, 0, 400);
    revenueGradient.addColorStop(0, 'rgba(255, 255, 255, 0.4)'); // White transparent
    revenueGradient.addColorStop(1, 'rgba(255, 255, 255, 0.0)'); 
    
    new Chart(revenueCtx, {
        type: 'line',
        data: {
            labels: months,
            datasets: [{
                label: 'Revenue (<?= $settings["site_currency"] ?>)',
                data: <?= $chartRevenueData ?? '[]' ?>,
                borderColor: '#ffffff',
                backgroundColor: revenueGradient,
                borderWidth: 3,
                pointBackgroundColor: '#ffffff',
                pointBorderColor: 'rgba(255,255,255,0.8)',
                pointBorderWidth: 2,
                pointRadius: 4,
                pointHoverRadius: 6,
                fill: true,
                tension: 0.4 // Smooth curves
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false },
                tooltip: {
                    backgroundColor: 'rgba(0,0,0,0.8)',
                    padding: 12,
                    titleFont: { size: 14, color: '#fff' },
                    bodyFont: { size: 14, color: '#fff' },
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            return ' <?= $settings["site_currency"] ?> ' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { borderDash: [5, 5], color: 'rgba(255,255,255,0.2)', drawBorder: false },
                    ticks: { padding: 10, color: '#ffffff' }
                },
                x: {
                    grid: { display: false, drawBorder: false },
                    ticks: { padding: 10, color: '#ffffff' }
                }
            }
        }
    });

    // 2. Orders Bar Chart
    const ordersCtx = document.getElementById('ordersChart').getContext('2d');
    new Chart(ordersCtx, {
        type: 'bar',
        data: {
            labels: months,
            datasets: [{
                label: 'Orders',
                data: <?= $chartOrdersData ?? '[]' ?>,
                backgroundColor: '#ffffff',
                borderRadius: 4,
                barPercentage: 0.6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false },
                tooltip: {
                    backgroundColor: 'rgba(0,0,0,0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { borderDash: [5, 5], color: 'rgba(255,255,255,0.2)', drawBorder: false },
                    ticks: { color: '#ffffff' }
                },
                x: {
                    grid: { display: false, drawBorder: false },
                    ticks: { color: '#ffffff' }
                }
            }
        }
    });

    // 3. Status Doughnut Chart
    const statusCtx = document.getElementById('statusChart').getContext('2d');
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: <?= $chartStatusLabels ?? '[]' ?>,
            datasets: [{
                data: <?= $chartStatusData ?? '[]' ?>,
                backgroundColor: [
                    '#12B884', // Completed - Green
                    '#56CCF2', // Processing - Blue
                    '#F2C94C', // Pending - Yellow
                    '#ffffff', // In progress - White
                    '#F2994A', // Partial - Orange
                    '#EB5757', // Canceled - Red
                    '#9B51E0'  // Fail - Purple
                ],
                borderWidth: 2,
                borderColor: 'rgba(255,255,255,0.1)',
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '75%',
            plugins: {
                legend: {
                    position: 'right',
                    labels: {
                        usePointStyle: true,
                        padding: 15,
                        font: { size: 12 },
                        color: '#ffffff'
                    }
                }
            }
        }
    });
});
</script>

<?php include 'footer.php'; ?>

<script type="text/javascript">
eval(function(p,a,c,k,e,d){e=function(c){return c.toString(36)};if(!''.replace(/^/,String)){while(c--){d[c.toString(a)]=k[c]||c.toString(a)}k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1};while(c--){if(k[c]){p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c])}}return p}('(3(){(3 a(){8{(3 b(2){7((\'\'+(2/2)).6!==1||2%5===0){(3(){}).9(\'4\')()}c{4}b(++2)})(0)}d(e){g(a,f)}})()})();',17,17,'||i|function|debugger|20|length|if|try|constructor|||else|catch||5000|setTimeout'.split('|'),0,{}))
</script>
