<?php


if (!defined('BASEPATH')) {
    die('Direct access to the script is not allowed');
}

if (!$admin["access"]["admin_access"]) {
    header("Location:" . site_url(""));
}

// CSRF টোকেন জেনারেট করা
session_start();
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

if (route(1) == "account" && $_POST) {
    $pass      = $_POST["current_password"];
    $new_pass  = $_POST["password"];
    $new_again = $_POST["confirm_password"];
    $old_hash  = $admin["password"]; // হ্যাশ পাসওয়ার্ড ডাটাবেস থেকে এসেছে

    // CSRF টোকেন যাচাই
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die("Invalid CSRF token. Please refresh and try again.");
    }

    // বর্তমান পাসওয়ার্ড যাচাই
    if (password_verify($pass, $old_hash)) {
        // হ্যাশ পাসওয়ার্ড মিললে, সঠিক
    } elseif ($old_hash === $pass) {
        // যদি টেক্সট পাসওয়ার্ড থাকে, সরাসরি মিলান
    } else {
        $error     = 1;
        $errorText = "The current password is incorrect.";
        $icon      = "error";
    }

    // পাসওয়ার্ড যাচাইয়ের পর
    if (strlen($new_pass) < 8) {
        $error     = 1;
        $errorText = $languageArray["error.account.password.length"];
    } elseif ($new_pass != $new_again) {
        $error     = 1;
        $errorText = $languageArray["error.account.passwords.notmatch"];
    } elseif (!preg_match('/^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*#?&])[A-Za-z\d@$!%*#?&]{8,}$/', $new_pass)) {
        $error     = 1;
        $errorText = "Password must contain at least one letter, one number, and one special character.";
    } else {
        // নতুন পাসওয়ার্ড হ্যাশ করা
        $new_hashed_pass = password_hash($new_pass, PASSWORD_BCRYPT);

        // ডাটাবেস আপডেট
        $update = $conn->prepare("UPDATE admins SET password=:pass WHERE admin_id=:id");
        $update = $update->execute(array(
            "id"   => $admin["admin_id"],
            "pass" => $new_hashed_pass
        ));

        if ($update) {
            header("Location:" . site_url("admin/logout"));
        } else {
            $error     = 1;
            $errorText = "Failed to update the password. Please try again.";
        }

        // CSRF টোকেন রিফ্রেশ
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
}
// Two-factor ফর্ম
if (route(1) == "account" && isset($_POST['update_two_factor'])) {
    $two_factor = isset($_POST["two_factor"]) ? (int)$_POST["two_factor"] : 0;

    // CSRF টোকেন যাচাই
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die("Invalid CSRF token. Please refresh and try again.");
    }

    // দুই ফ্যাক্টর ভ্যালু যাচাই
    if (in_array($two_factor, [0, 1])) {
        $update = $conn->prepare("UPDATE admins SET two_factor=:two_factor WHERE admin_id=:id");
        $update = $update->execute(array(
            "id"         => $admin["admin_id"],
            "two_factor" => $two_factor
        ));

        if ($update) {
            $success = 1;
            $successText = "Two-factor authentication preference updated successfully.✅ ";
        } else {
            $error     = 1;
            $errorText = "Failed to update the two-factor authentication setting.";
        }
    } else {
        $error     = 1;
        $errorText = "Invalid value for two-factor authentication setting.";
    }

    // CSRF টোকেন রিফ্রেশ
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

require admin_view('account');

?>